<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'db.php';

$response = ['success' => false, 'message' => '', 'data' => null];

try {
    // Get ID from request
    $id = isset($_GET['id']) ? intval($_GET['id']) : 0;
    
    if ($id <= 0) {
        throw new Exception('Invalid category ID');
    }

    // Prepare and execute query
    $sql = "SELECT * FROM blog_category WHERE Blog_category_id = ? AND Delete_status = 0";
    $stmt = $conn->prepare($sql);
    
    if (!$stmt) {
        throw new Exception('Database preparation error: ' . $conn->error);
    }
    
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $category = $result->fetch_assoc();
        
        $response = [
            'success' => true,
            'message' => 'Category fetched successfully',
            'data' => $category
        ];
    } else {
        throw new Exception('Category not found', 404);
    }
    
    $stmt->close();
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
    http_response_code($e->getCode() ?: 500);
}

$conn->close();
echo json_encode($response);
?>